unit PwdDlg;

interface

uses
  SysUtils, Types, Classes, Variants, QTypes, QGraphics, QControls, QForms, 
  QDialogs, QStdCtrls, QExtCtrls, CustomRar;

type
  TPwdDlg = class(TForm)
    Lbl: TLabel;
    ed: TEdit;
    okBtn: TButton;
    canBtn: TButton;
    chb: TCheckBox;
    Image1: TImage;
    procedure okBtnClick(Sender: TObject);
    procedure edReturnPressed(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
    constructor Create(AOwner:TComponent);override;
    procedure AfterConstruction;override;
  end;

var
  PwdSfa   : Boolean;
  PwdPwd   : String;

implementation

{$R *.xfm}

procedure TPwdDlg.okBtnClick(Sender: TObject);
begin
  PwdSfa:=chb.Checked;
  PwdPwd:=ed.Text;
end;

constructor TPwdDlg.Create(AOwner:TComponent);
begin
  inherited;
  PwdPwd:='';
  PwdSfa:=false;
end;

procedure TPwdDlg.edReturnPressed(Sender: TObject);
begin
  okBtn.SetFocus;
end;

procedure TPwdDlg.AfterConstruction;
begin
  self.Caption:=DLG_PWD_TITLE;
  Lbl.Caption:=DLG_PWD_LABEL;
  canBtn.Caption:=DLG_CANCEL;
  okBtn.Caption:=DLG_OK;
  chb.Caption:=DLG_PWD_SAMEFORALL;
end;

end.
